/*
 * Decompiled with CFR 0.152.
 */
package com.grepbugs.plugin.eclipse;

import com.grepbugs.plugin.eclipse.IRulesProvider;
import com.grepbugs.plugin.eclipse.Rule;
import com.grepbugs.plugin.eclipse.RulesJSONProcessor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;

public class URLRulesProvider
implements IRulesProvider {
    private static final String GREPRULES_FILE = "greprules.json";
    private static final String FAILED_TO_CREATE_GREP_RULES_FILE = "Failed to create grep rules file";
    private static final String NO_CACHED_GREP_RULES_EXIST = "No cached grep rules exist";
    private static final String STALE_GREP_RULES_ARE_BEING_USED = "Stale grep rules are being used.";
    private static final String FAILED_TO_DOWNLOAD_GREP_RULES = "Failed to download grep rules.";
    private String url = "https://grepbugs.com/rules";

    @Override
    public Collection<Rule> fetchRules(String fileToStore, Collection<String> messages) throws Exception {
        File targetRulesFile;
        Collection<Rule> rules;
        block8: {
            String jsonFileName = String.valueOf(File.separator) + GREPRULES_FILE;
            rules = new ArrayList<Rule>();
            Path target = Paths.get(String.valueOf(fileToStore) + jsonFileName, new String[0]);
            File rulesFile = target.toFile();
            boolean oldRulesFileExists = rulesFile.exists();
            targetRulesFile = null;
            if (oldRulesFileExists) {
                targetRulesFile = rulesFile;
            }
            String tempFilePath = String.valueOf(fileToStore) + File.separator + "temp.json";
            Path tempTarget = Paths.get(tempFilePath, new String[0]);
            File jsonFile = tempTarget.toFile();
            boolean copyFile = true;
            boolean fileExists = jsonFile.exists();
            if (fileExists) {
                jsonFile.delete();
            }
            if (copyFile = jsonFile.createNewFile()) {
                try {
                    this.saveFile(tempFilePath, this.url);
                    rulesFile.delete();
                    jsonFile.renameTo(rulesFile);
                    targetRulesFile = rulesFile;
                }
                catch (Exception exception) {
                    messages.add(FAILED_TO_DOWNLOAD_GREP_RULES);
                    if (oldRulesFileExists) {
                        messages.add(STALE_GREP_RULES_ARE_BEING_USED);
                        break block8;
                    }
                    messages.add(NO_CACHED_GREP_RULES_EXIST);
                    rules = null;
                }
            } else {
                messages.add(FAILED_TO_CREATE_GREP_RULES_FILE);
            }
        }
        if (targetRulesFile != null) {
            rules = RulesJSONProcessor.INSTANCE.parseRules(targetRulesFile);
        }
        return rules;
    }

    private void saveFile(String fileName, String url) throws Exception {
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            URL urlObject = new URL(url);
            URLConnection connection = urlObject.openConnection();
            connection.addRequestProperty("User-Agent", "GrepBugs for Eclipse (1.0)");
            in = new BufferedInputStream(connection.getInputStream());
            fout = new FileOutputStream(fileName);
            byte[] data = new byte[1024];
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }
}

