/*
 * Decompiled with CFR 0.152.
 */
package com.grepbugs.plugin.eclipse;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.grepbugs.plugin.eclipse.Rule;
import com.grepbugs.plugin.eclipse.ScanResult;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.Validate;

public class RulesJSONProcessor {
    public static RulesJSONProcessor INSTANCE = new RulesJSONProcessor();

    private RulesJSONProcessor() {
    }

    public Collection<Rule> parseRules(File jsonFile) throws FileNotFoundException {
        Validate.notNull((Object)jsonFile, (String)"file should not be null");
        Gson gson = new Gson();
        FileReader in = new FileReader(jsonFile);
        JsonReader reader = new JsonReader((Reader)in);
        Rule[] rules = (Rule[])gson.fromJson(reader, Rule[].class);
        return Arrays.asList(rules);
    }

    public ScanResult fetchResults(String fileName) throws FileNotFoundException {
        Validate.notNull((Object)fileName, (String)"file should not be null");
        Gson gson = new Gson();
        FileReader in = new FileReader(fileName);
        JsonReader reader = new JsonReader((Reader)in);
        ScanResult result = (ScanResult)gson.fromJson(reader, ScanResult.class);
        return result;
    }

    public void storeResults(ScanResult searchResult, String fileName) throws IOException {
        Validate.notNull((Object)fileName, (String)" file to store search result should not be null");
        File file = new File(fileName);
        Gson gson = new Gson();
        String jsonString = gson.toJson((Object)searchResult);
        if (file.exists()) {
            file.delete();
            file.createNewFile();
        }
        ByteArrayInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            in = new ByteArrayInputStream(jsonString.getBytes());
            fout = new FileOutputStream(file);
            byte[] data = new byte[1024];
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }
}

