/*
 * Decompiled with CFR 0.152.
 */
package com.grepbugs.plugin.eclipse.ui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.grepbugs.plugin.eclipse.Activator;
import com.grepbugs.plugin.eclipse.CodeScanner;
import com.grepbugs.plugin.eclipse.Rule;
import com.grepbugs.plugin.eclipse.RuleScanResult;
import com.grepbugs.plugin.eclipse.RulesJSONProcessor;
import com.grepbugs.plugin.eclipse.ScanResult;
import com.grepbugs.plugin.eclipse.SearchFileDescriptor;
import com.grepbugs.plugin.eclipse.ui.Messages;
import com.grepbugs.plugin.eclipse.ui.SWTResourceManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class CodeScannerView
extends ViewPart {
    private static final String PROJECT_CLOSED = "Project Closed";
    private static final String GREPRESULTS_FILE = "grepresults.json";
    public static final String ID = "com.grepbugs.codescanner.view";
    private TableViewer tagsViewer;
    private TableViewer matchResultsViewer;
    private Map<Rule, Collection<SearchFileDescriptor>> results = Maps.newHashMap();
    private Label loadLbl;
    private Link noResultsLbl;

    public void createPartControl(Composite parent) {
        Control resultsControl;
        SashForm base = new SashForm(parent, 256);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(2, 2).applyTo((Composite)base);
        Composite leftComp = new Composite((Composite)base, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(2, 2).applyTo(leftComp);
        GridData data = new GridData(1808);
        leftComp.setLayoutData((Object)data);
        this.loadLbl = new Label(leftComp, 0);
        data = new GridData(768);
        this.loadLbl.setLayoutData((Object)data);
        this.loadLbl.setFont(SWTResourceManager.getBoldFont(this.loadLbl.getFont()));
        Composite tagsComp = new Composite(leftComp, 2048);
        data = new GridData(1808);
        tagsComp.setLayoutData((Object)data);
        StackLayout stackLayout = new StackLayout();
        tagsComp.setLayout((Layout)stackLayout);
        this.noResultsLbl = new Link(tagsComp, 64);
        this.noResultsLbl.setText(Messages.CodeScannerView_NO_BUGS_FOUND);
        stackLayout.topControl = resultsControl = this.buildTagsViewer(tagsComp);
        final CTabFolder folder = new CTabFolder((Composite)base, 2048);
        Color selectionBgColor = folder.getDisplay().getSystemColor(15);
        folder.setSelectionBackground(selectionBgColor);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(Messages.CodeScannerView_MATCHES);
        Control matchResultControl = this.buildMatchResultsViewer((Composite)folder);
        item.setControl(matchResultControl);
        item = new CTabItem(folder, 0);
        item.setText(Messages.CodeScannerView_DESCRITION);
        Composite descComp = new Composite((Composite)folder, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(2, 2).applyTo(descComp);
        final StyledText descriptinLbl = new StyledText(descComp, 74);
        data = new GridData(1808);
        descriptinLbl.setLayoutData((Object)data);
        item.setControl((Control)descComp);
        item = new CTabItem(folder, 0);
        item.setText(Messages.CodeScannerView_REGEX);
        Composite regExComp = new Composite((Composite)folder, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(2, 2).applyTo(regExComp);
        final StyledText regExLbl = new StyledText(regExComp, 74);
        item.setControl((Control)regExComp);
        data = new GridData(1808);
        regExLbl.setLayoutData((Object)data);
        item = new CTabItem(folder, 0);
        item.setText(Messages.CodeScannerView_ABOUT);
        Composite aboutComp = new Composite((Composite)folder, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(2, 2).applyTo(aboutComp);
        Link aboutLbl = new Link(aboutComp, 74);
        aboutLbl.setText(Messages.CodeScannerView_ABOUT_TEXT);
        item.setControl((Control)aboutComp);
        data = new GridData(1808);
        aboutLbl.setLayoutData((Object)data);
        data = new GridData(1808);
        folder.setLayoutData((Object)data);
        this.tagsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Collection searchDescriptors;
                ISelection selection = event.getSelection();
                Rule rule = null;
                if (!selection.isEmpty()) {
                    rule = (Rule)((IStructuredSelection)selection).getFirstElement();
                }
                if ((searchDescriptors = (Collection)CodeScannerView.this.results.get(rule)) == null) {
                    searchDescriptors = Sets.newHashSet();
                }
                CodeScannerView.this.matchResultsViewer.setInput((Object)searchDescriptors.toArray());
                String description = "";
                if (rule != null) {
                    description = rule.getDescription();
                }
                descriptinLbl.setText(description != null ? description : "");
                String regEx = "";
                if (rule != null) {
                    regEx = rule.getRegex();
                }
                regExLbl.setText(regEx != null ? regEx : "");
                if (folder.getSelectionIndex() == -1) {
                    folder.setSelection(0);
                }
            }
        });
        this.matchResultsViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                block10: {
                    ISelection selection = event.getSelection();
                    SearchFileDescriptor searchFileDescriptor = null;
                    if (!selection.isEmpty()) {
                        searchFileDescriptor = (SearchFileDescriptor)((IStructuredSelection)selection).getFirstElement();
                    }
                    if (searchFileDescriptor != null) {
                        String projectName;
                        String path = searchFileDescriptor.getPath();
                        IWorkspace workspace = ResourcesPlugin.getWorkspace();
                        IWorkspaceRoot root = workspace.getRoot();
                        IProject project = root.getProject(projectName = searchFileDescriptor.getProjectName());
                        if (project != null) {
                            if (project.isAccessible()) {
                                IFile file = project.getFile(path);
                                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                try {
                                    IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                                    if (!(editorPart instanceof ITextEditor)) break block10;
                                    ITextEditor editor = (ITextEditor)editorPart;
                                    IDocumentProvider provider = editor.getDocumentProvider();
                                    IDocument document = provider.getDocument((Object)editor.getEditorInput());
                                    try {
                                        int start = document.getLineOffset(searchFileDescriptor.getLine());
                                        editor.selectAndReveal(Math.max(start - 1, 0), 0);
                                        IWorkbenchPage editorPage = editor.getSite().getPage();
                                        editorPage.activate((IWorkbenchPart)editor);
                                    }
                                    catch (BadLocationException badLocationException) {
                                    }
                                }
                                catch (PartInitException partInitException) {
                                    MessageDialog.openError((Shell)CodeScannerView.this.getViewSite().getShell(), (String)"Error", (String)"Failed to open Grepbugs view");
                                }
                            } else {
                                MessageDialog.openInformation((Shell)CodeScannerView.this.getViewSite().getShell(), (String)CodeScannerView.PROJECT_CLOSED, (String)Messages.bind((String)Messages.CodeScannerView_PROJECT_CLOSED, (Object)project.getName()));
                            }
                        } else {
                            Policy.getLog().log((IStatus)new Status(2, "com.grepbugs.plugin.eclipse", "project not found in workspace project:" + projectName));
                        }
                    }
                }
            }
        });
        base.setWeights(new int[]{50, 50});
        this.loadSavedResults();
    }

    private Control buildMatchResultsViewer(Composite parent) {
        this.matchResultsViewer = new TableViewer(parent, 67588);
        this.autoResizeViewer(this.matchResultsViewer);
        TableViewerColumn column = new TableViewerColumn(this.matchResultsViewer, 0);
        column.getColumn().setText(Messages.CodeScannerView_RULE);
        column.getColumn().setWidth(100);
        this.matchResultsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof SearchFileDescriptor) {
                    SearchFileDescriptor result = (SearchFileDescriptor)element;
                    return StringUtils.join((Object[])new String[]{result.getDisplayName(), Messages.CodeScannerView_LINE, String.valueOf(result.getLine())});
                }
                return "";
            }
        });
        this.matchResultsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.matchResultsViewer.getTable().setHeaderVisible(false);
        this.matchResultsViewer.getTable().setLinesVisible(false);
        this.matchResultsViewer.setComparator(new ViewerComparator((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        }));
        return this.matchResultsViewer.getControl();
    }

    private void autoResizeViewer(final TableViewer viewer) {
        viewer.getTable().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Table table = viewer.getTable();
                int columnCount = table.getColumnCount();
                if (columnCount == 0) {
                    return;
                }
                Rectangle area = table.getClientArea();
                int totalAreaWdith = area.width;
                int lineWidth = table.getGridLineWidth();
                int totalGridLineWidth = (columnCount - 1) * lineWidth;
                int totalColumnWidth = 0;
                TableColumn[] tableColumnArray = table.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    totalColumnWidth += column.getWidth();
                    ++n2;
                }
                int diff = totalAreaWdith - (totalColumnWidth + totalGridLineWidth);
                TableColumn[] tableColumnArray2 = table.getColumns();
                int n3 = tableColumnArray2.length;
                n = 0;
                while (n < n3) {
                    TableColumn column = tableColumnArray2[n];
                    int pixels = (int)((float)diff * ((float)column.getWidth() * 1.0f / (float)totalColumnWidth));
                    column.setWidth(column.getWidth() + pixels);
                    ++n;
                }
            }
        });
    }

    private Control buildTagsViewer(Composite parent) {
        this.tagsViewer = new TableViewer(parent, 66052);
        this.autoResizeViewer(this.tagsViewer);
        TableViewerColumn column = new TableViewerColumn(this.tagsViewer, 0);
        column.getColumn().setText(Messages.CodeScannerView_RULE_LABEL);
        column.getColumn().setWidth(100);
        this.tagsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Rule) {
                    Rule rule = (Rule)element;
                    Collection searchDescriptors = (Collection)CodeScannerView.this.results.get(rule);
                    if (searchDescriptors == null) {
                        searchDescriptors = Sets.newHashSet();
                    }
                    return StringUtils.join((Object[])new String[]{rule.getTags(), " (", String.valueOf(searchDescriptors.size()), ")"});
                }
                return "";
            }
        });
        this.tagsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tagsViewer.getTable().setHeaderVisible(false);
        this.tagsViewer.getTable().setLinesVisible(false);
        this.tagsViewer.setComparator(new ViewerComparator((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        }));
        return this.tagsViewer.getControl();
    }

    public void setFocus() {
    }

    public void scan(Collection<IProject> projects) {
        this.scanProjects(projects);
    }

    private void loadSavedResults() {
        String fileName = this.getScanResultFileLocation();
        try {
            ScanResult result = RulesJSONProcessor.INSTANCE.fetchResults(fileName);
            this.results.clear();
            if (result.getRuleResults() != null) {
                for (RuleScanResult ruleResult : result.getRuleResults()) {
                    this.results.put(ruleResult.getRule(), ruleResult.getDescriptors());
                }
            }
            this.tagsViewer.setInput((Object)this.results.keySet().toArray());
            this.tagsViewer.setSelection((ISelection)(this.results.isEmpty() ? StructuredSelection.EMPTY : new StructuredSelection((Object)this.results.keySet().iterator().next())));
            this.loadLbl.setText(Messages.bind((String)Messages.CodeScannerView_SCANRESULTS_TIME, (Object)DateFormat.getDateTimeInstance().format(result.getSearchDate())));
        }
        catch (FileNotFoundException e) {
            Policy.logException((Exception)e);
        }
    }

    private void scanProjects(Collection<IProject> projects) {
        block13: {
            CodeScanner scanner = new CodeScanner();
            String lblTxt = "";
            try {
                try {
                    lblTxt = Messages.CodeScannerView_SCAN_LABEL;
                    this.loadLbl.setText(lblTxt);
                    HashSet messages = Sets.newHashSet();
                    Map<Rule, Collection<SearchFileDescriptor>> recentResults = scanner.scan(projects, messages);
                    this.results.clear();
                    if (recentResults != null) {
                        this.results.putAll(recentResults);
                    }
                    this.tagsViewer.setInput((Object)this.results.keySet().toArray());
                    this.tagsViewer.setSelection((ISelection)(this.results.isEmpty() ? StructuredSelection.EMPTY : new StructuredSelection((Object)this.results.keySet().iterator().next())));
                    if (recentResults != null && recentResults.isEmpty()) {
                        this.showResultsEmptyMsg();
                    } else {
                        this.showTagsControl();
                    }
                    if (!messages.isEmpty()) {
                        MessageDialog.openInformation((Shell)this.getViewSite().getShell(), (String)Messages.CodeScannerView_INFORMATION, (String)StringUtils.join((Collection)messages, (String)" "));
                    }
                    lblTxt = Messages.bind((String)Messages.CodeScannerView_SCANRESULTS_TIME, (Object)DateFormat.getDateTimeInstance().format(new Date()));
                }
                catch (Exception e1) {
                    Policy.logException((Exception)e1);
                    MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)Messages.CodeScannerView_ERROR, (String)(String.valueOf(Messages.CodeScannerView_FAILED_DOWNLOAD) + e1.getMessage()));
                    lblTxt = "";
                    this.loadLbl.setText(lblTxt);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                this.loadLbl.setText(lblTxt);
                throw throwable;
            }
            this.loadLbl.setText(lblTxt);
        }
        if (this.results != null) {
            ScanResult scanResult = new ScanResult();
            ArrayList ruleResults = Lists.newArrayList();
            for (Map.Entry<Rule, Collection<SearchFileDescriptor>> e : this.results.entrySet()) {
                RuleScanResult ruleResult = new RuleScanResult();
                ruleResult.setRule(e.getKey());
                ruleResult.setDescriptors(e.getValue());
                ruleResults.add(ruleResult);
            }
            scanResult.setRuleResults(ruleResults);
            scanResult.setSearchDate(new Date());
            String jsonFileName = this.getScanResultFileLocation();
            try {
                RulesJSONProcessor.INSTANCE.storeResults(scanResult, jsonFileName);
            }
            catch (IOException e) {
                Policy.logException((Exception)e);
            }
        }
    }

    private void showTagsControl() {
        Composite comp = this.tagsViewer.getControl().getParent();
        ((StackLayout)comp.getLayout()).topControl = this.tagsViewer.getControl();
        comp.layout(true);
    }

    private void showResultsEmptyMsg() {
        Composite comp = this.tagsViewer.getControl().getParent();
        ((StackLayout)comp.getLayout()).topControl = this.noResultsLbl;
        comp.layout(true);
    }

    private String getScanResultFileLocation() {
        IPath path = Activator.getDefault().getStateLocation();
        String folderLoc = path.toOSString();
        String jsonFileName = String.valueOf(folderLoc) + File.separator + GREPRESULTS_FILE;
        return jsonFileName;
    }
}

