/*
 * Decompiled with CFR 0.152.
 */
package com.grepbugs.plugin.eclipse;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import com.grepbugs.plugin.eclipse.Activator;
import com.grepbugs.plugin.eclipse.Rule;
import com.grepbugs.plugin.eclipse.SearchFileDescriptor;
import com.grepbugs.plugin.eclipse.URLRulesProvider;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.Policy;

public class CodeScanner {
    private static final Object PROJECT_SCAN_JOB = new Object();

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public Map<Rule, Collection<SearchFileDescriptor>> scan(Collection<IProject> projects, Collection<String> messages) throws Exception {
        resultsMap = Maps.newConcurrentMap();
        provider = new URLRulesProvider();
        path = Activator.getDefault().getStateLocation();
        folderLoc = path.toOSString();
        jsonFileLoc = folderLoc;
        rules = provider.fetchRules(jsonFileLoc, messages);
        if (rules == null) {
            return null;
        }
        if (rules.isEmpty()) {
            return resultsMap;
        }
        jobs = Lists.newArrayList();
        for (IProject project : projects) {
            if (!project.isAccessible()) continue;
            job = new ProjectScanJob(project, rules);
            jobs.add(job);
            job.schedule();
        }
        try {
            try {
                Job.getJobManager().join(CodeScanner.PROJECT_SCAN_JOB, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                Policy.logException((Exception)e);
                throw e;
            }
        }
        finally {
            collectedResultsMap = Maps.newConcurrentMap();
            ** for (job : jobs)
        }
lbl-1000:
        // 1 sources

        {
            results = job.getResultsMap();
            for (Map.Entry<Rule, Collection<SearchFileDescriptor>> e : results.entrySet()) {
                collectedResults = (Collection)collectedResultsMap.get(e.getKey());
                if (collectedResults == null) {
                    collectedResults = Sets.newHashSet();
                    collectedResultsMap.put(e.getKey(), collectedResults);
                }
                collectedResults.addAll(e.getValue());
            }
            continue;
        }
lbl40:
        // 3 sources

        for (Map.Entry e : collectedResultsMap.entrySet()) {
            resultsByRule = (Collection)e.getValue();
            if (resultsByRule == null || resultsByRule.isEmpty()) continue;
            resultsMap.put((Rule)e.getKey(), resultsByRule);
        }
        return resultsMap;
    }

    private static class ProjectScanJob
    extends Job {
        private IProject project;
        private Collection<Rule> rules;
        private Map<Rule, Collection<SearchFileDescriptor>> resultsMap;

        public ProjectScanJob(IProject project, Collection<Rule> rules) {
            super("Grepbugs:Scanning Project " + project.getName());
            this.project = project;
            this.rules = rules;
            this.resultsMap = Maps.newHashMap();
        }

        public Map<Rule, Collection<SearchFileDescriptor>> getResultsMap() {
            return this.resultsMap;
        }

        public boolean belongsTo(Object family) {
            return PROJECT_SCAN_JOB == family;
        }

        protected IStatus run(IProgressMonitor monitor) {
            ArrayList<IResource> children = new ArrayList<IResource>();
            this.collectAllChildren((IResource)this.project, children);
            for (IResource resource : children) {
                if (resource.getType() != 1) continue;
                for (Rule rule : this.rules) {
                    String fileExtn;
                    String extn = rule.getExtension();
                    String[] extns = StringUtils.split((String)extn, (char)',');
                    HashSet<String> extensions = new HashSet<String>(Arrays.asList(extns));
                    if (!extensions.contains(StringUtils.lowerCase((String)(fileExtn = resource.getFileExtension())))) continue;
                    File file = resource.getLocation().toFile();
                    File projectFile = this.project.getLocation().toFile();
                    HashSet results = Sets.newHashSet();
                    this.findMatches(projectFile, file, rule, results);
                    HashSet collectedResults = this.resultsMap.get(rule);
                    if (collectedResults != null) {
                        collectedResults.addAll(results);
                    } else {
                        collectedResults = results;
                    }
                    this.resultsMap.put(rule, collectedResults);
                }
            }
            return Status.OK_STATUS;
        }

        private void findMatches(File projectFolder, File file, Rule rule, Collection<SearchFileDescriptor> results) {
            String regex = rule.getRegex();
            Pattern pattern = Pattern.compile(regex);
            try {
                List allLines = (List)Files.readLines((File)file, (Charset)Charsets.UTF_8, (LineProcessor)new LineProcessor<List<String>>(){
                    List<String> result = Lists.newArrayList();

                    public boolean processLine(String line) {
                        this.result.add(line);
                        return true;
                    }

                    public List<String> getResult() {
                        return this.result;
                    }
                });
                int lineNum = 0;
                for (String line : allLines) {
                    Matcher matcher = pattern.matcher(line);
                    while (matcher.find()) {
                        int end;
                        int start = matcher.start();
                        if (start == (end = matcher.end())) continue;
                        SearchFileDescriptor descriptor = new SearchFileDescriptor();
                        descriptor.setLine(lineNum + 1);
                        String projectName = projectFolder.getName();
                        String filePath = file.getAbsolutePath();
                        String relativePath = StringUtils.substringAfter((String)filePath, (String)projectFolder.getAbsolutePath());
                        String displayName = String.valueOf(projectName) + relativePath;
                        descriptor.setDisplayName(displayName);
                        descriptor.setPath(relativePath);
                        descriptor.setProjectName(projectName);
                        descriptor.setStart(start);
                        descriptor.setEnd(end);
                        results.add(descriptor);
                    }
                    ++lineNum;
                }
            }
            catch (IOException e) {
                Policy.logException((Exception)e);
            }
        }

        private List<IResource> collectAllChildren(IResource resource, List<IResource> children) {
            IResource[] members;
            if (resource.getType() == 1) {
                return children;
            }
            try {
                members = ((IContainer)resource).members();
            }
            catch (CoreException coreException) {
                return children;
            }
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource m = iResourceArray[n2];
                if (1 == m.getType()) {
                    children.add(m);
                } else {
                    this.collectAllChildren(m, children);
                }
                ++n2;
            }
            return children;
        }
    }
}

